	function PLOT_ATT_TG_S2(Att, Taug, omega, axis_Amax, axis_Tg_max)
 
	%	Plots the attenuation and group delay for an analog filter in a single figure
 
	% 	Toolbox for DIGITAl FILTERS USING MATLAB 
	
	% 	Author: 		Lars Wanhammar 2007-09-13, 2017-07-11
	% 	Modified by: 	 	 
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1
	% 	Known bugs:		Zoom  does not work properly
	% 	Report bugs to:	Wanhammar@gmail.com
 
	%========================================================	
	% Standard settings
	fs = 16; % Font size
	lw = 2; % Linewidth
	fn = 'times'; % Font
	%========================================================

	subplot('position', [0.1 0.4 0.80 0.5]);
	[AX, H1, H2] = plotyy(omega,Att, omega,Taug);
 	set(AX(2),'xtick',[]);
	set(H1, 'linewidth', lw);
	set(H2, 'linewidth', lw);
	set(AX(1), 'ylim', [0 axis_Amax]);
	set(AX(1), 'ytick', [0:10:axis_Amax]);
	set(AX(2), 'ylim', [0 axis_Tg_max]);
	set(AX(2), 'ytick', [0:axis_Tg_max*10/axis_Amax:axis_Tg_max]);
 
	axes(AX(1))
	set(gca,'FontName', fn,'FontSize', fs);
	ylabel('{\itA}({\it\omega})  [dB]','FontName',fn,'FontSize',fs);	
	xlabel('{\it\omega}  [rad/s]','FontName', fn,'FontSize',fs);
	grid on;
	axes(AX(2))
	set(gca,'FontName', fn,'FontSize', fs);
	ylabel('{\it\tau_g}({\it\omega})  [s]','FontName', fn,'FontSize',fs);	
 
